    /*/////////////////////////////////////////////
    // n <- freedom; p <- dimension of variable  //
    /////////////////////////////////////////////*/

void   wishart(W,n,p,RW)

int    n, p;
float  **W, **RW;

{ 

  int   i, j, k, l;
  long  idum;
  float **TT;
  float **W1,**W0;

  TT=matrix(1,p,1,p);
  W0=matrix(1,p,1,p);
  W1=matrix(1,p,1,p);

  for (i=1;i<=p;i++) {
       for (j=1;j<i;j++) {
            idum=rand();
            TT[i][j]=gasdev(&idum);
            TT[j][i]=0.0;
            }
       TT[i][i]=sqrt(gamm3((float)(n-i+1)/2,2.0));
       }
    
  for (i=1;i<=p;i++)
       for (j=1;j<=p;j++) {
            W0[i][j]=0.0;
            for(k=1; k<=p; k++)
                W0[i][j]+=TT[i][k]*TT[j][k];
            }

  /* W0 is standard wishart; W1 is Cholosky decomposition */

  choldc(W,p,W1);
  for (i=1;i<=p;i++)
       for (j=1;j<=p;j++)  {
            RW[i][j]=0.0;
            for(k=1;k<=p;k++)
                for(l=1;l<=p;l++)
                      RW[i][j]+=W1[i][k]*W0[k][l]*W1[j][l];
            }

  free_matrix(TT,1,p,1,p);
  free_matrix(W0,1,p,1,p);
  free_matrix(W1,1,p,1,p);
}
